//By Z22, suggested fixes by TheEmu

uniform sampler2D texture0;
uniform vec2 textureSize0;
vec2 vTexCoord = gl_TexCoord[0].xy;
vec2 fm1 = vec2 (0.0);

///////////////////////////////////////////////////////////////////////////////////////////

vec2 Glass(vec2 Distortion)
{
	
// Get a float offset that equates to 1 pixel in the x and y
//(20.0) overkill chrome, (10.0) bit like dichroic glass sometimes, (0.25) very low distortion.

	vec2 Offset = vec2(1.0) / textureSize0;  

// Use the Offset for the lookup of r,g,b

	vec4 G1 = texture2D ( texture0, vTexCoord.xy + Offset*vec2( 0.0,-1.0) ) ;
	vec4 G3 = texture2D ( texture0, vTexCoord.xy + Offset*vec2(-1.0, 0.0) ) ;
	vec4 G4 = texture2D ( texture0, vTexCoord.xy + Offset*vec2( 0.0, 0.0) ) ;

//Combine r,g,b 

	float CastFix0 = ( ( 2.0*((G1.r + G1.g + G1.b)*0.333)) -1.0); 
	float CastFix1 = ( ( 2.0*((G3.r + G3.g + G3.b)*0.333)) -1.0);//Doing these seperatly ((2.0*g1.r)-1) breaks the mirroring.
	float CastFix2 = ( ( 2.0*((G4.r + G4.g + G4.b)*0.333)) -1.0);

//Combine position and (r,g,b)

	vec3 Gray1 = (G1.x, G1.y, CastFix0 );
	vec3 Gray3 = (G3.x, G3.y, CastFix1 );
	vec3 Gray4 = (G4.x, G4.y, CastFix2 );


	vec3 cp0 = ((1.0+Gray4)*0.5) * ((1.0+Gray1)*0.5);
	vec3 cp1 = ((1.0+Gray4)*0.5) * ((1.0+Gray3)*0.5);

// Use to offset float x and y

	vec3 combo = (cp0 + cp1)*0.5;

	float x = ( ((2.0*combo.r)-1.0)+((2.0*combo.b)-1.0)*0.5 )* (Offset*128.0); 
	float y = ( ((2.0*combo.b)-1.0)+((2.0*combo.g)-1.0)*0.5 )* (Offset*128.0);

	Distortion.x = (Distortion.x)+0.5 ; //Horizontal offset
	
//Combine the offsets and return out of Wibble routine.

	return vec2(Distortion.x+x, Distortion.y+y); 
}
///////////////////////////////////////////////////////////////////////////////////////////
void main(void)
{
//Magic. 
 	gl_FragColor = texture2D(texture0, Glass(vTexCoord)) ;
}
//Enjoy! :D Z22.